#ifdef GL_ES
precision mediump float;

varying vec3 normal;
varying vec2 vTexCoord;

vec4 fragColor;
#else
in vec3 normal;
in vec2 vTexCoord;

out vec4 fragColor;
#endif
uniform sampler2D colorTex;
uniform sampler2D normalTex;
uniform float brightness;

uniform vec3 lightSource4;
uniform vec3 lightSource4HV;

void main()
{
    vec3 norm = normalize(normal);
    float lambert = dot(norm, lightSource4);
	
    float specular = pow(dot(norm, lightSource4HV), 8.0);
    float diffuse = lambert * (0.75 * 0.75) * brightness;
		
#ifdef GL_ES
    vec4 tColor = texture2D(colorTex, vTexCoord.st);
#else
    vec4 tColor = texture(colorTex, vTexCoord.st);
#endif
    fragColor = vec4((tColor.rgb * diffuse) + vec3(specular * tColor.a), 1.0);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
